﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Domaine
{
    /// <summary>
    /// Modélise un utilisateur de la bibliothèque
    /// </summary>
    public class Utilisateur
    {
        private int id;
        private string nom;
        private string prenom;

        /// <summary>
        /// Constructeur
        /// </summary>
        /// <param name="id"></param>
        /// <param name="nom"></param>
        /// <param name="prenom"></param>
        public Utilisateur(int id, string nom, string prenom)
        {
            this.id = id;
            this.nom = nom;
            this.prenom = prenom;
        }

        public Utilisateur(string nom, string prenom)
        {
            this.nom = nom;
            this.prenom = prenom;
        }

        /// <summary>
        /// IDentifiant de l'utilisateur
        /// </summary>
        public int Id
        {
            get { return id; }
            set { id = value; }
        }
        
        /// <summary>
        /// Nom de l'utilisateur
        /// </summary>
        public string Nom
        {
            get { return nom; }
            set { nom = value; }
        }
        
        /// <summary>
        /// Prénom de l'utilisateur
        /// </summary>
        public string Prenom
        {
            get { return prenom; }
            set { prenom = value; }
        }

        /// <summary>
        /// Décrit un utilisateur
        /// </summary>
        /// <returns></returns>
        public override string ToString()
        {
            return Prenom + " " + Nom;
        }
    }
}
